<div class="modal-header preview" v-if="$store.getters.getConditionData">
    <div class="modal-header__title">
        <div class="modal-title">
            <span style="color: #000000 !important;">
                <?php esc_html_e('Edit Link', 'cost-calculator-builder')?>:
            </span> {{ getByAlias($store.getters.getConditionData.optionFrom).label || 'Element From' }}
            <span style="opacity: 0.7; padding: 0 5px">&rarr;</span>
            {{ getByAlias($store.getters.getConditionData.optionTo).label || 'Element From' }}
        </div>
    </div>
</div>
<div class="modal-body condition">
    <div v-for="(model, index) in $store.getters.getConditionModel" v-if="$store.getters.getConditionModel.length > 0">
<!--        TITLES-->
        <div class="ccb-select-label-wrap" v-if="$store.getters.getConditionModel.length">
            <label class="ccb-select-label"><?php esc_html_e('Condition', 'cost-calculator-builder')?></label>
            <label class="ccb-select-label"><?php esc_html_e('Value', 'cost-calculator-builder')?></label>
            <label class="ccb-select-label"><?php esc_html_e('Action', 'cost-calculator-builder')?></label>
            <label :style="'flex-grow: '  + $store.getters.getStaticConditionActionsByValue(model.action).flex_grow + ';'" class="ccb-select-label" v-if="$store.getters.getStaticConditionActionsByValue(model.action) && $store.getters.getStaticConditionActionsByValue(model.action).hasOwnProperty('title') && $store.getters.getStaticConditionActionsByValue(model.action).flex_grow > 0">
                {{ $store.getters.getStaticConditionActionsByValue(model.action).title }}
            </label>
        </div>
<!--        TITLES-->

        <div class="ccb-select-wrap">
            <!--        CONDITION STATE START-->
            <div class="ccb-condition">
                <select class="ccb-condition-select" v-model="model.condition">
                    <option value=""><?php esc_html_e('Select Condition', 'cost-calculator-builder')?></option>
                    <option v-for="(conditionState, key) in  $store.getters.getStaticConditionStatesByField( $store.getters.getConditionData.optionFrom )" :value="conditionState.value">
                        {{ conditionState.title }}
                    </option>
                </select>
            </div>
            <!--        CONDITION STATE END-->

            <div class="ccb-condition">
                <!--        FROM FIELD - VALUE FOR SELECT | START-->
                <select class="ccb-condition-select" v-model="model.key" v-if="$store.getters.getConditionData.type === 'select'">
                    <option  value=""><?php esc_html_e('- Select Option -', 'cost-calculator-builder')?></option>
                    <option v-for="(item, key) in $store.getters.getConditionOptions" :value="key">
                        {{ item.optionText }}
                    </option>
                </select>
                <!--        FROM FIELD - VALUE FOR SELECT | END-->

                <!--        FROM FIELD - VALUE FOR INPUT | START-->
                <input v-else type="number" class="ccb-condition-select" v-model="model.value">
            </div>
            <!--        FROM FIELD - VALUE FOR INPUT | END-->

            <!--        ACTIONS START-->
            <div class="ccb-condition">
                <select @change="cleanSetVal(index)" class="ccb-condition-select" v-model="model.action">
                    <option value=""><?php esc_html_e('- Select Action -', 'cost-calculator-builder')?></option>
                    <option v-for="conditionActions in $store.getters.getStaticConditionActionsByField($store.getters.getConditionData.optionTo)" :value="conditionActions.value">
                        {{ ( conditionActions.title.length > 15 && model.action == conditionActions.value ) ? conditionActions.title.substring(0, 15) + ' ...' : conditionActions.title  }}
                    </option>
                </select>
            </div>
            <!--        ACTIONS END-->

            <!--        SET VALUE START-->
            <div class="ccb-condition" v-if="model.action === 'set_value' || model.action === 'set_value_and_disable'">
                <input  type="number" class="ccb-condition-select" v-model="model.setVal">
            </div>
            <!--        SET VALUE END-->

            <!--        SET DATE START-->
            <div class="ccb-condition" v-if="model.action === 'set_date' || model.action === 'set_date_and_disable'">
                <div class="ccb-custom-input-date">
                <span v-if="model.setVal.length > 0" class="ccb-date-value" >
                    {{ model.setVal }}
                    <i class="far fa-times-circle fa-lg" @click="cleanSetVal(index)"></i>
                </span>
                    <span v-else class="ccb-date-value">
                    <?php esc_html_e('- Select Date -', 'cost-calculator-builder')?>
                </span>
                    <span v-if="model.setVal.length <= 0" class="ccb-datepicker-toggle">
                  <span class="datepicker-toggle-button"></span>
                  <input type="date" class="datepicker-input" @change="setDate(event, index)">
                </span>
                </div>
            </div>
            <!--        SET DATE END-->

            <!--        SET PERIOD FOR DATE WITH RANGE START-->
            <!--        start date-->
            <div class="ccb-condition" v-if="$store.getters.getFieldNameByFieldId($store.getters.getConditionData.optionTo) == 'datePicker' && ( model.action === 'set_period' || model.action === 'set_period_and_disable') ">
                <div class="ccb-custom-input-date">
                <span v-if="( model.setVal.length > 0 && JSON.parse(model.setVal).hasOwnProperty('start') && JSON.parse(model.setVal)['start'].length > 0)" class="ccb-date-value range" >
                    {{ JSON.parse(model.setVal)['start'] }}
                    <i class="far fa-times-circle fa-lg" @click="cleanDateRangeSetVal(index, 'start')"></i>
                </span>
                    <span v-else class="ccb-date-value range">
                    <?php esc_html_e('From', 'cost-calculator-builder')?>
                </span>
                    <span class="ccb-datepicker-toggle" v-if="( model.setVal.length <= 0 || !JSON.parse(model.setVal).hasOwnProperty('start') || JSON.parse(model.setVal)['start'].length <= 0)">
                  <span class="datepicker-toggle-button"></span>
                  <input type="date" name="start" class="datepicker-input" @change="setRangeDate(event, index)">
                </span>
                </div>
                <span class="error-tip" v-if="errors.range_date_error != null" v-html="errors.range_date_error"></span>
            </div>
            <!--        end date-->
            <div class="ccb-condition" v-if="$store.getters.getFieldNameByFieldId($store.getters.getConditionData.optionTo) == 'datePicker' && ( model.action === 'set_period' || model.action === 'set_period_and_disable') ">
                <div class="ccb-custom-input-date">
                <span v-if="( model.setVal.length > 0 && JSON.parse(model.setVal).hasOwnProperty('end') && JSON.parse(model.setVal)['end'].length > 0 )" class="ccb-date-value range" >
                    {{ JSON.parse(model.setVal)['end'] }}
                    <i class="far fa-times-circle fa-lg" @click="cleanDateRangeSetVal(index, 'end')"></i>
                </span>
                    <span v-else class="ccb-date-value range">
                    <?php esc_html_e('To', 'cost-calculator-builder')?>
                </span>
                    <span class="ccb-datepicker-toggle" v-if="( model.setVal.length <= 0 || !JSON.parse(model.setVal).hasOwnProperty('end') || JSON.parse(model.setVal)['end'].length <= 0)">
                  <span class="datepicker-toggle-button"></span>
                  <input type="date" name="end" class="datepicker-input" @change="setRangeDate(event, index)">
                </span>
                </div>
            </div>
            <!--        SET PERIOD FOR DATE WITH RANGE END-->


            <!--        SET PERIOD FOR MULTI RANGE START-->
            <div class="ccb-condition" v-if="$store.getters.getFieldNameByFieldId($store.getters.getConditionData.optionTo) == 'multi_range' && ( model.action === 'set_period' || model.action === 'set_period_and_disable') ">
                <input placeholder="<?php esc_html_e('From', 'cost-calculator-builder')?>" @change="setMultiRange(event, index)" type="number" name="start" class="ccb-condition-select" :value="( model.setVal.length > 0 && JSON.parse(model.setVal).hasOwnProperty('start')) ? JSON.parse(model.setVal)['start']: ''">
                <span class="error-tip" v-if="errors.multi_range_error != null" v-html="errors.multi_range_error"></span>
            </div>
            <div class="ccb-condition" v-if="$store.getters.getFieldNameByFieldId($store.getters.getConditionData.optionTo) == 'multi_range' && ( model.action === 'set_period' || model.action === 'set_period_and_disable') ">
                <input placeholder="<?php esc_html_e('To', 'cost-calculator-builder')?>" @change="setMultiRange(event, index)" type="number" name="end" class="ccb-condition-select" :value="( model.setVal.length > 0 && JSON.parse(model.setVal).hasOwnProperty('end')) ? JSON.parse(model.setVal)['end']: ''">
            </div>
            <!--        SET PERIOD FOR MULTI RANGE END-->


            <!--        SET OPTION  START-->
            <div class="ccb-condition" v-if="model.action === 'select_option' || model.action === 'select_option_and_disable'">
                <!--        FOR multiple items (checkbox, toggle) -->
                <div v-if="['checkbox', 'toggle'].includes( $store.getters.getFieldNameByFieldId($store.getters.getConditionData.optionTo))" class="ccb-condition-select multiselect" tabindex="100">
                <span v-if="model.setVal.length > 0" class="anchor" @click.prevent="multiselectShow(event)">
                    {{ model.setVal.split(',').length }} <?php esc_html_e('options selected', 'cost-calculator-builder')?>
                </span>
                    <span v-else class="anchor" @click.prevent="multiselectShow(event)">
                    <?php esc_html_e('- Select Option -', 'cost-calculator-builder')?>
                </span>
                    <ul class="items">
                        <li class="option-item" @click.self="multiselectChoose(event, optionIndex, index)"  v-for="(item, optionIndex) in $store.getters.getFieldOptionsByFieldId($store.getters.getConditionData.optionTo)" >
                            <input :checked="( model.setVal.length > 0 && model.setVal.split(',').map(Number).includes(optionIndex))" @change="multiselectChoose(event, optionIndex);" :class="['index',optionIndex].join('_')" type="checkbox"  />{{ item.optionText }}
                        </li>
                    </ul>
                    <input v-model="model.setVal" name="options" type="hidden" :class="$store.getters.getConditionData.optionTo"   />
                </div>

                <!--        FOR one value (radio, dropDown) -->
                <select v-else name="setOptions[]" class="ccb-condition-select" v-model="model.setVal" >
                    <option  value=""><?php esc_html_e('- Select Option -', 'cost-calculator-builder')?></option>
                    <option v-for="(item, optionIndex) in $store.getters.getFieldOptionsByFieldId($store.getters.getConditionData.optionTo)" :value="optionIndex">
                        {{ item.optionText }}
                    </option>
                </select>
            </div>
            <!--        SET OPTION END-->

            <div class="remove-wrap">
                <i class="far fa-times-circle" @click.prevent="removeRow(index)"></i>
            </div>
        </div>
    </div>


    <div v-if="!$store.getters.getConditionModel.length" class="modal-body">
        <p style="color: #333333; width: 100%; text-align: center; padding: 5px; opacity: .7">
            <?php esc_html_e('No Conditions Yet', 'cost-calculator-builder')?>
        </p>
    </div>
</div>
<div class="modal-footer" style="padding: 5px 0; display: block">
    <div class="list-row existing">
        <div class="list-content" style="display: flex; justify-content: space-between">
            <div class="list-btn-item">
                <button  @click.prevent="addModel"  type="button" class="green">
                    <i class="fas fa-plus"></i>
                    <span><?php esc_html_e('Add condition', 'cost-calculator-builder')?></span>
                </button>
            </div>

            <div class="list-btn-item" style="display: flex">
                <button type="button" class="white" @click.prevent="removeLink()" style="margin-right: 10px">
                    <i class="fas fa-trash"></i>
                    <span><?php esc_html_e('Delete Link', 'cost-calculator-builder')?></span>
                </button>

                <button type="button" class="green" @click.prevent="saveLink">
                    <i class="fas fa-save"></i>
                    <span><?php esc_html_e('Save Link', 'cost-calculator-builder')?></span>
                </button>
            </div>
        </div>
    </div>
</div>